import { defineConfig } from 'vite'
import type { Plugin } from 'vite'
import tailwindcss from '@tailwindcss/vite'

function delayIndexCssPlugin(): Plugin {
  let server
  return {
    name: 'delay-index-css',
    enforce: 'pre',
    configureServer(_server) {
      server = _server
    },
    async load(id) {
      if (server && id.includes('index.css')) {
        await server.waitForRequestsIdle(id)
      }
    },
  }
}

export default defineConfig({
  resolve: {
    alias: {
      '/@': import.meta.dirname,
    },
  },
  build: {
    // to make tests faster
    minify: false,
  },
  plugins: [
    {
      name: 'delay view',
      enforce: 'pre',
      async transform(_code, id) {
        if (id.includes('views/view1.js')) {
          await new Promise((resolve) => setTimeout(resolve, 100))
        }
      },
    },
    delayIndexCssPlugin(),
    tailwindcss(),
  ],
})
