<?php
namespace Bpost;

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../../../../autoload.php';

use TijsVerkoyen\Bpost\Bpost\Label;

class LabelTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Create a generic DOM Document
     *
     * @return \DOMDocument
     */
    private static function createDomDocument()
    {
        $document = new \DOMDocument('1.0', 'utf-8');
        $document->preserveWhiteSpace = false;
        $document->formatOutput = true;

        return $document;
    }

    /**
     * Tests Order->toXML
     */
    public function testCreateFromXML()
    {
        $data = array(
            'barcode' => '323212345659900357662030',
            'mimeType' => 'image/png',
            'bytes' => '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',

        );

        $document = self::createDomDocument();
        $labelElement = $document->createElement('label');
        foreach ($data as $key => $value) {
            $labelElement->appendChild(
                $document->createElement($key, $value)
            );
        }
        $document->appendChild($labelElement);

        $label = Label::createFromXML(
            simplexml_load_string(
                $document->saveXML()
            )
        );

        $this->assertEquals($data['barcode'], $label->getBarcode());
        $this->assertEquals($data['mimeType'], $label->getMimeType());
        $this->assertEquals(base64_decode($data['bytes']), $label->getBytes());
    }

    /**
     * Test validation in the setters
     */
    public function testFaultyProperties()
    {
        $label = new Label();

        try {
            $label->setMimeType(str_repeat('a', 9));
        } catch (\Exception $e) {
            $this->assertInstanceOf('TijsVerkoyen\Bpost\Exception', $e);
            $this->assertEquals(
                'Invalid value, possible values are: ' . implode(', ', Label::getPossibleMimeTypeValues()) . '.',
                $e->getMessage()
            );
        }
    }
}
