using System;
using Content.Shared.GameObjects.Components.Movement;
using JetBrains.Annotations;
using Robust.Client.GameObjects;
using Robust.Client.Interfaces.GameObjects.Components;

namespace Content.Client.GameObjects.Components.Movement
{
    [UsedImplicitly]
    public class HandTeleporterVisualizer2D : AppearanceVisualizer
    {

        public override void OnChangeData(AppearanceComponent component)
        {
            var sprite = component.Owner.GetComponent<ISpriteComponent>();
            if (!component.TryGetData(TeleporterVisuals.VisualState, out TeleporterVisualState state))
            {
                state = TeleporterVisualState.Ready;
            }

            switch (state)
            {
                case TeleporterVisualState.Charging:
                    sprite.LayerSetState(0, "charging");
                    break;
                case TeleporterVisualState.Ready:
                    sprite.LayerSetState(0, "ready");
                    break;
                default:
                    throw new ArgumentOutOfRangeException();
            }
        }
    }

}
