## Governance of the Horovod Project

Horovod is a graduated projected within the [LF AI & Data Foundation](https://lfaidata.foundation/).

### Charter

You can find Horovod Charter [here](https://wiki.lfai.foundation/download/attachments/7733301/Horovod%20Project%20Technical%20Charter%2012-22-2018%20FINAL.pdf?version=1&modificationDate=1558389484000&api=v2)

### Technical Steering Committee

Horovod development is governed by the Horovod Technical Steering Committee (TSC). The TSC consists of voting and
non-voting members, in addition to a chairman responsible for running TSC meetings, setting the meeting agenda, and
calling votes on proposals.

Current chairman of the Horovod TSC:
* [Travis Addair](https://github.com/tgaddair) - Predibase

Current voting members of the Horovod TSC:
* [Alex Sergeev](https://github.com/alsrgv) - Carbon Robotics
* [Travis Addair](https://github.com/tgaddair) - Predibase
* [Can Karakus](https://github.com/karakusc) - Amazon
* [Josh Romero](https://github.com/romerojosh) - NVIDIA
* [Nicolas Castet](https://github.com/nvcastet) - NVIDIA
* [Enrico Minack](https://github.com/EnricoMi) - G-Research
* [Xu Ning](https://github.com/thuningxu) - Uber
* [Todd Mytkowicz](https://github.com/klipto) - Microsoft

Current non-voting members of the Horovod TSC:
* [Leonard Lausen](https://github.com/leezu) - Amazon
* [Jonathan Dekhtiar](https://github.com/DEKHTIARJonathan) - NVIDIA
* [Richard Liaw](https://github.com/richardliaw) - Anyscale
* [Neil Conway](https://github.com/neilconway) - Determined AI, HPE
* [Min Cai](https://github.com/mincai) - Uber
* [Chongxiao Cao](https://github.com/chongxiaoc) - Uber
* [Max Gerlach](https://github.com/maxhgerlach) - DeepL
* [Ryan Beethe](https://github.com/rb-determined-ai) - Determined AI, HPE
* [Abin Shahab](https://github.com/ashahab) - LinkedIn
* [TJ Xu](https://github.com/Tixxx) - Uber

Emeritus members of the Horovod TSC:
* [Lin Yuan](https://github.com/apeforest)
* [Haibin Lin](https://github.com/eric-haibin-lin)
* [Yuxi Hu](https://github.com/yuxihu)
* [Emad Barsoum](https://github.com/ebarsoum)
* [Aaron Harlap](https://github.com/aaron276h)
* [Jaliya Ekanayake](https://github.com/jaliyae)
* [Kaarthik Sivashanmugam](https://github.com/skaarthik)
* [Armand McQueen](https://github.com/armandmcqueen)

Non-voting members of the TSC ("maintainers") have commit access to the Horovod GitHub repository, and take part in the
standing TSC meetings and mailing lists. Emeritus members are no longer active maintainers of the project, but are
welcome to participate in any TSC meeting.

The Horovod TSC meets monthly and publishes meeting notes via a [mailing list](https://lists.lfai.foundation/g/horovod-tsc).
This mailing list can also be utilized to reach out to the TSC.  Major decisions regarding the technical directions of
the Horovod project will be brought before the TSC for discussion, with an accompanying proposal document termed an RFC
(Request for Comments).

Technical decisions made by the TSC should be unanimous, with each voting and non-voting member either agreeing to the
proposal or abstaining for it to pass.  If consensus cannot be reached, then the proposal is to be put to a vote
among the voting members of the TSC, at which point a majority of the voting TSC must agree to the proposal for it to
pass.

Decisions to add or change members of the TSC in either a voting or non-voting capacity are handled the same as other
proposals (without an RFC): an attempt is made to reach a unanimous decision among the entire TSC, followed by a vote
among the voting members if no consensus can be reached.
