# 前言

Flask 是一个使用 Python 语言编写的 Web 框架，它可以让你高效的编写 Web 程序。Web 程序即“网站”或“网页程序”，是指可以通过浏览器进行交互的程序。我们日常使用浏览器访问的豆瓣、知乎、百度等网站都是 Web 程序。

通过这本书，你会学到 Flask 开发的基础知识，并开发出一个简单的 Watchlist（观影清单）程序。在功能上，这个程序可以看做是简化版的 IMDB Watchlist / 豆瓣豆单：你可以添加、删除和修改你收藏的电影信息。

![Watchlist 程序](images/7-2.png)

你可以访问 http://watchlist.helloflask.com/ 查看示例程序的在线 Demo。

## 本书特点

- 基于 Flask 最新的 1.0.2 版本
- 使用一个 Watchlist 程序作为示例
- 复原完整的开发流程
- 只提供入门所需的最少信息
- 优化术语解释，更容易理解

## 阅读方法

本书复原了编写这个 Watchlist 程序的完整流程，包括每一行代码块，每一个需要执行的命令。在阅读时，你需要自己输入每一个代码和命令，检查输出是否和书中一致。在这个过程中，你也可以对它进行一些调整。比如，示例程序的界面语言使用了英文，你可以修改为中文或是其他语言。对于页面布局和样式，你也可以自由修改。

在本书的最后，你会把你自己编写的 Watchlist 部署到互联网上，让任何人都可以访问。

## 讨论与反馈

如果你有任何疑问和想法，欢迎通过下面的方式提出：

* 在 [HelloFlask 论坛](https://discuss.helloflask.com)发布帖子，并选择“Flask 入门教程”分类。
* 在专栏对应的连载文章下面撰写评论。
* 在源码仓库[创建 Issue](https://github.com/greyli/flask-tutorial/issues/new)。

## 相关资源

* 本书主页：http://helloflask.com/tutorial
* 本书论坛：https://discuss.helloflask.com
* 本书源码：https://github.com/greyli/flask-tutorial
* 本书示例程序源码：https://github.com/greyli/watchlist
* 示例程序在线 Demo：http://watchlist.helloflask.com