/*
Copyright 2022 The OpenFunction Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1beta2

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1beta2 "github.com/openfunction/apis/core/v1beta2"
	scheme "github.com/openfunction/pkg/client/clientset/versioned/scheme"
)

// ServingsGetter has a method to return a ServingInterface.
// A group's client should implement this interface.
type ServingsGetter interface {
	Servings(namespace string) ServingInterface
}

// ServingInterface has methods to work with Serving resources.
type ServingInterface interface {
	Create(ctx context.Context, serving *v1beta2.Serving, opts v1.CreateOptions) (*v1beta2.Serving, error)
	Update(ctx context.Context, serving *v1beta2.Serving, opts v1.UpdateOptions) (*v1beta2.Serving, error)
	UpdateStatus(ctx context.Context, serving *v1beta2.Serving, opts v1.UpdateOptions) (*v1beta2.Serving, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta2.Serving, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta2.ServingList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta2.Serving, err error)
	ServingExpansion
}

// servings implements ServingInterface
type servings struct {
	client rest.Interface
	ns     string
}

// newServings returns a Servings
func newServings(c *CoreV1beta2Client, namespace string) *servings {
	return &servings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the serving, and returns the corresponding serving object, and an error if there is any.
func (c *servings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta2.Serving, err error) {
	result = &v1beta2.Serving{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("servings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Servings that match those selectors.
func (c *servings) List(ctx context.Context, opts v1.ListOptions) (result *v1beta2.ServingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta2.ServingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("servings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested servings.
func (c *servings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("servings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a serving and creates it.  Returns the server's representation of the serving, and an error, if there is any.
func (c *servings) Create(ctx context.Context, serving *v1beta2.Serving, opts v1.CreateOptions) (result *v1beta2.Serving, err error) {
	result = &v1beta2.Serving{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("servings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serving).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a serving and updates it. Returns the server's representation of the serving, and an error, if there is any.
func (c *servings) Update(ctx context.Context, serving *v1beta2.Serving, opts v1.UpdateOptions) (result *v1beta2.Serving, err error) {
	result = &v1beta2.Serving{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("servings").
		Name(serving.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serving).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *servings) UpdateStatus(ctx context.Context, serving *v1beta2.Serving, opts v1.UpdateOptions) (result *v1beta2.Serving, err error) {
	result = &v1beta2.Serving{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("servings").
		Name(serving.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serving).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the serving and deletes it. Returns an error if one occurs.
func (c *servings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("servings").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *servings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("servings").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched serving.
func (c *servings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta2.Serving, err error) {
	result = &v1beta2.Serving{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("servings").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
