/*
Copyright 2022 The OpenFunction Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1beta2

import (
	rest "k8s.io/client-go/rest"

	v1beta2 "github.com/openfunction/apis/core/v1beta2"
	"github.com/openfunction/pkg/client/clientset/versioned/scheme"
)

type CoreV1beta2Interface interface {
	RESTClient() rest.Interface
	BuildersGetter
	FunctionsGetter
	ServingsGetter
}

// CoreV1beta2Client is used to interact with features provided by the core.openfunction.io group.
type CoreV1beta2Client struct {
	restClient rest.Interface
}

func (c *CoreV1beta2Client) Builders(namespace string) BuilderInterface {
	return newBuilders(c, namespace)
}

func (c *CoreV1beta2Client) Functions(namespace string) FunctionInterface {
	return newFunctions(c, namespace)
}

func (c *CoreV1beta2Client) Servings(namespace string) ServingInterface {
	return newServings(c, namespace)
}

// NewForConfig creates a new CoreV1beta2Client for the given config.
func NewForConfig(c *rest.Config) (*CoreV1beta2Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &CoreV1beta2Client{client}, nil
}

// NewForConfigOrDie creates a new CoreV1beta2Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *CoreV1beta2Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new CoreV1beta2Client for the given RESTClient.
func New(c rest.Interface) *CoreV1beta2Client {
	return &CoreV1beta2Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1beta2.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *CoreV1beta2Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
