/*
Copyright 2022 The OpenFunction Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1beta1 "github.com/openfunction/apis/core/v1beta1"
	scheme "github.com/openfunction/pkg/client/clientset/versioned/scheme"
)

// BuildersGetter has a method to return a BuilderInterface.
// A group's client should implement this interface.
type BuildersGetter interface {
	Builders(namespace string) BuilderInterface
}

// BuilderInterface has methods to work with Builder resources.
type BuilderInterface interface {
	Create(ctx context.Context, builder *v1beta1.Builder, opts v1.CreateOptions) (*v1beta1.Builder, error)
	Update(ctx context.Context, builder *v1beta1.Builder, opts v1.UpdateOptions) (*v1beta1.Builder, error)
	UpdateStatus(ctx context.Context, builder *v1beta1.Builder, opts v1.UpdateOptions) (*v1beta1.Builder, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.Builder, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.BuilderList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Builder, err error)
	BuilderExpansion
}

// builders implements BuilderInterface
type builders struct {
	client rest.Interface
	ns     string
}

// newBuilders returns a Builders
func newBuilders(c *CoreV1beta1Client, namespace string) *builders {
	return &builders{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the builder, and returns the corresponding builder object, and an error if there is any.
func (c *builders) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.Builder, err error) {
	result = &v1beta1.Builder{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("builders").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Builders that match those selectors.
func (c *builders) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.BuilderList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.BuilderList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("builders").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested builders.
func (c *builders) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("builders").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a builder and creates it.  Returns the server's representation of the builder, and an error, if there is any.
func (c *builders) Create(ctx context.Context, builder *v1beta1.Builder, opts v1.CreateOptions) (result *v1beta1.Builder, err error) {
	result = &v1beta1.Builder{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("builders").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(builder).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a builder and updates it. Returns the server's representation of the builder, and an error, if there is any.
func (c *builders) Update(ctx context.Context, builder *v1beta1.Builder, opts v1.UpdateOptions) (result *v1beta1.Builder, err error) {
	result = &v1beta1.Builder{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("builders").
		Name(builder.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(builder).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *builders) UpdateStatus(ctx context.Context, builder *v1beta1.Builder, opts v1.UpdateOptions) (result *v1beta1.Builder, err error) {
	result = &v1beta1.Builder{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("builders").
		Name(builder.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(builder).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the builder and deletes it. Returns an error if one occurs.
func (c *builders) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("builders").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *builders) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("builders").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched builder.
func (c *builders) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.Builder, err error) {
	result = &v1beta1.Builder{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("builders").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
