# Governance

This document defines the project governance for OpenFunction.

## Community Roles

* **Users:** Members that engage with the OpenFunction community via any medium (Slack, WeChat, GitHub, mailing lists, etc.).
* **Contributors:** Regular contributions to projects (documentation, code reviews, responding to issues, participation in proposal discussions, contributing code, etc.). 
* **Maintainers**: The OpenFunction project leaders. They are responsible for the overall health and direction of the project; final reviewers of PRs and responsible for releases. Some Maintainers are responsible for one or more components within a project, acting as technical leads for that component. Maintainers are expected to contribute code and documentation, review PRs including ensuring the quality of code, triage issues, proactively fix bugs, and perform maintenance tasks for these components.

## Voting

All decisions made by maintainers have to be a [super-majority](https://en.wikipedia.org/wiki/Supermajority#Two-thirds_vote).

## Project Maintainers

[Project maintainers](OWNERS) are responsible for activities around maintaining and updating the OpenFunction. Final decisions on the features reside with the project maintainers.

Maintainers MUST remain active. If they are unresponsive for >3 months, they will be automatically removed unless a [super-majority](https://en.wikipedia.org/wiki/Supermajority#Two-thirds_vote) of the other project maintainers agrees to extend the period to be greater than 3 months.

New maintainers can be added to the project by a [super-majority](https://en.wikipedia.org/wiki/Supermajority#Two-thirds_vote) vote of the existing maintainers. A potential maintainer may be nominated by an existing maintainer. A vote is conducted in private between the current maintainers over the course of a one-week voting period. At the end of the week, votes are counted and a pull request is made on the repo adding the new maintainer to the [Project maintainers](OWNERS) file.

Individuals interested in becoming maintainers may submit an [issue](https://github.com/OpenFunction/OpenFunction/issues/new) stating their interest. Existing maintainers can choose if they would like to nominate these individuals to be a maintainer following the process above.

A maintainer may step down by submitting an [issue](https://github.com/OpenFunction/OpenFunction/issues/new) stating their intent.

Changes to this governance document require a pull request with approval from a [super-majority](https://en.wikipedia.org/wiki/Supermajority#Two-thirds_vote) of the current maintainers.

## Managing Projects

New projects can be added to the organization after a successful [super-majority](https://en.wikipedia.org/wiki/Supermajority#Two-thirds_vote) vote of the existing maintainers.

When OpenFunction wants to archive an existing project, maintainers have to vote where a [super-majority](https://en.wikipedia.org/wiki/Supermajority#Two-thirds_vote) of the current maintainers agrees to archive the project with a clear indication of why it is being archived. We must not delete projects to avoid customer confusion.
