/*
Copyright 2022 The OpenFunction Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1alpha1 "github.com/openfunction/apis/events/v1alpha1"
	scheme "github.com/openfunction/pkg/client/clientset/versioned/scheme"
)

// EventBusesGetter has a method to return a EventBusInterface.
// A group's client should implement this interface.
type EventBusesGetter interface {
	EventBuses(namespace string) EventBusInterface
}

// EventBusInterface has methods to work with EventBus resources.
type EventBusInterface interface {
	Create(ctx context.Context, eventBus *v1alpha1.EventBus, opts v1.CreateOptions) (*v1alpha1.EventBus, error)
	Update(ctx context.Context, eventBus *v1alpha1.EventBus, opts v1.UpdateOptions) (*v1alpha1.EventBus, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.EventBus, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.EventBusList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.EventBus, err error)
	EventBusExpansion
}

// eventBuses implements EventBusInterface
type eventBuses struct {
	client rest.Interface
	ns     string
}

// newEventBuses returns a EventBuses
func newEventBuses(c *EventsV1alpha1Client, namespace string) *eventBuses {
	return &eventBuses{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the eventBus, and returns the corresponding eventBus object, and an error if there is any.
func (c *eventBuses) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.EventBus, err error) {
	result = &v1alpha1.EventBus{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("eventbuses").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of EventBuses that match those selectors.
func (c *eventBuses) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.EventBusList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.EventBusList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("eventbuses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested eventBuses.
func (c *eventBuses) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("eventbuses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a eventBus and creates it.  Returns the server's representation of the eventBus, and an error, if there is any.
func (c *eventBuses) Create(ctx context.Context, eventBus *v1alpha1.EventBus, opts v1.CreateOptions) (result *v1alpha1.EventBus, err error) {
	result = &v1alpha1.EventBus{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("eventbuses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(eventBus).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a eventBus and updates it. Returns the server's representation of the eventBus, and an error, if there is any.
func (c *eventBuses) Update(ctx context.Context, eventBus *v1alpha1.EventBus, opts v1.UpdateOptions) (result *v1alpha1.EventBus, err error) {
	result = &v1alpha1.EventBus{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("eventbuses").
		Name(eventBus.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(eventBus).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the eventBus and deletes it. Returns an error if one occurs.
func (c *eventBuses) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("eventbuses").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *eventBuses) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("eventbuses").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched eventBus.
func (c *eventBuses) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.EventBus, err error) {
	result = &v1alpha1.EventBus{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("eventbuses").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
